using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace FM12XXTest
{
    public partial class Form1 : Form
    {
        [DllImport("umf.dll", EntryPoint = "fw_config_card")]
        public static extern Int32 fw_config_card(Int32 icdev, Byte cardtype);


        [DllImport("umf.dll", EntryPoint = "fw_init")]
        public static extern Int32 fw_init(Int16 port, Int32 baud);
        [DllImport("umf.dll", EntryPoint = "fw_exit")]
        public static extern Int32 fw_exit(Int32 icdev);
        [DllImport("umf.dll", EntryPoint = "fw_request")]
        public static extern Int32 fw_request(Int32 icdev, Byte _Mode, ref UInt32 TagType);
        [DllImport("umf.dll", EntryPoint = "fw_anticoll")]
        public static extern Int32 fw_anticoll(Int32 icdev, Byte _Bcnt, ref UInt32 _Snr);
        [DllImport("umf.dll", EntryPoint = "fw_select")]
        public static extern Int32 fw_select(Int32 icdev, UInt32 _Snr, ref Byte _Size);
        [DllImport("umf.dll", EntryPoint = "fw_card")]
        public static extern Int32 fw_card(Int32 icdev, Byte _Mode, ref UInt32 _Snr);
        [DllImport("umf.dll", EntryPoint = "fw_load_key")]
        public static extern Int32 fw_load_key(Int32 icdev, Byte _Mode, Byte _SecNr, ref Byte _NKey);
        [DllImport("umf.dll", EntryPoint = "fw_authentication")]
        public static extern Int32 fw_authentication(Int32 icdev, Byte _Mode, Byte _SecNr);
        [DllImport("umf.dll", EntryPoint = "fw_read")]
        public static extern Int32 fw_read(Int32 icdev, Byte _Adr, ref Byte _Data);
        [DllImport("umf.dll", EntryPoint = "fw_write")]
        public static extern Int32 fw_write(Int32 icdev, Byte _Adr, ref Byte _Data);
        [DllImport("umf.dll", EntryPoint = "fw_halt")]
        public static extern Int32 fw_halt(Int32 icdev);
        [DllImport("umf.dll", EntryPoint = "fw_changeb3")]
        public static extern Int32 fw_changeb3(Int32 icdev, Byte _SecNr, ref Byte _KeyA, ref Byte _CtrlW, Byte _Bk,
                ref Byte _KeyB);
        [DllImport("umf.dll", EntryPoint = "fw_initval")]
        public static extern Int32 fw_initval(Int32 icdev, Byte _Adr, UInt32 _Value);
        [DllImport("umf.dll", EntryPoint = "fw_increment")]
        public static extern Int32 fw_increment(Int32 icdev, Byte _Adr, UInt32 _Value);
        [DllImport("umf.dll", EntryPoint = "fw_readval")]
        public static extern Int32 fw_readval(Int32 icdev, Byte _Adr, ref UInt32 _Value);
        [DllImport("umf.dll", EntryPoint = "fw_decrement")]
        public static extern Int32 fw_decrement(Int32 icdev, Byte _Adr, UInt32 _Value);
        [DllImport("umf.dll", EntryPoint = "fw_restore")]
        public static extern Int32 fw_restore(Int32 icdev, Byte _Adr);
        [DllImport("umf.dll", EntryPoint = "fw_transfer")]
        public static extern Int32 fw_transfer(Int32 icdev, Byte _Adr);
        [DllImport("umf.dll", EntryPoint = "fw_beep")]
        public static extern Int32 fw_beep(Int32 icdev, UInt32 _Msec);
        [DllImport("umf.dll", EntryPoint = "fw_getver")]
        public static extern Int32 fw_getver(Int32 icdev, ref Byte buff);
        [DllImport("umf.dll", EntryPoint = "fw_reset")]
        public static extern Int32 fw_reset(IntPtr icdev, UInt16 _Msec);
        [DllImport("umf.dll", EntryPoint = "fw_cpureset")]
        public static extern Int16 fw_cpureset(Int32 icdev, ref Byte rlen, ref Byte rdata);
        [DllImport("umf.dll", EntryPoint = "fw_pro_reset")]
        public static extern Int16 fw_pro_reset(Int32 icdev, ref Byte rlen, ref Byte rdata);
        [DllImport("umf.dll", EntryPoint = "fw_pro_commandlink")]
        public static extern Int16 fw_pro_commandlink(Int32 icdev, Byte slen, ref Byte sdata,
            ref Byte rlen, ref Byte rdata, Byte ftt, Byte fFG);
        [DllImport("umf.dll", EntryPoint = "fw_cpuapdu")]
        public static extern Int16 fw_cpuapdu(IntPtr icdev, Byte slen, ref Byte sdata, ref Byte rlen,
            ref Byte rdata);

        [DllImport("umf.dll", EntryPoint = "hex_a")]
        public static extern void hex_a(ref Byte hex, ref Byte a, Int32 len);
        [DllImport("umf.dll", EntryPoint = "a_hex")]
        public static extern void a_hex(ref Byte a, ref Byte hex, Int32 alen);

        //fm1208 functions
        [DllImport("umf.dll", EntryPoint = "FWCosSelecteApp")]
        public static extern UInt32 FWCosSelecteApp(Int32 icdev);
        [DllImport("umf.dll", EntryPoint = "FWCosCreateKeyFile")]
        public static extern UInt32 FWCosCreateKeyFile(Int32 icdev, short usDirFileID, short usFileID, short uFileLen, int ulGenSec);
        [DllImport("umf.dll", EntryPoint = "FWCosAddKey")]
        public static extern UInt32 FWCosAddKey(Int32 icdev, Byte bKeyType, ref Byte pbKeyValue, int ulKeyValueLen);
        [DllImport("umf.dll", EntryPoint = "FWCosVerifyKey")]
        public static extern UInt32 FWCosVerifyKey(Int32 icdev, ref Byte pbKey, int ulKeyLen, int ulKeyType);
        [DllImport("umf.dll", EntryPoint = "FWCosCreateBinaryFile")]
        public static extern UInt32 FWCosCreateBinaryFile(Int32 icdev, short usDirFileID, short usFileID, short usFileLen, Byte cryptyType, int ulReadSec, int ulUpdateSec, int ulDeleteSec);
        [DllImport("umf.dll", EntryPoint = "FWCosUpdateBinaryFile")]
        public static extern UInt32 FWCosUpdateBinaryFile(Int32 icdev, short usFileID, short usOffset, ref Byte pbBinData, short usUpdateLen, Byte cryptyType, ref Byte pProKey, int ulKeyLen);
        [DllImport("umf.dll", EntryPoint = "FWCosReadBinaryFile")]
        public static extern UInt32 FWCosReadBinaryFile(Int32 icdev, short usFileID, ref Byte pbBinData, short usOffset, short usReadLen, Byte cryptyType, ref Byte pProKey, int ulKeyLen);
        [DllImport("umf.dll", EntryPoint = "FWCosCreateADF")]
        public static extern UInt32 FWCosCreateADF(Int32 icdev, ushort usDirFileID, int ulCreateSec, int ulDeleteSec, ref char pbDirName, Byte ucDirNameLength);
        [DllImport("umf.dll", EntryPoint = "FWCosCredit")]
        public static extern UInt32 FWCosCredit(Int32 icdev, Byte ucKeyID, UInt32 value, ref Byte terminalID, ref Byte pbCreditKey, int ulCreditKeyLen);
        [DllImport("umf.dll", EntryPoint = "FWCosPurchase")]
        public static extern UInt32 FWCosPurchase(Int32 icdev, Byte ucKeyID, UInt32 value, ref Byte terminalID, ref Byte pbPurchaseKey, int ulPurchaseKeyLen);
        [DllImport("umf.dll", EntryPoint = "FWCosGetBalance")]
        public static extern UInt32 FWCosGetBalance(UInt32 icdev, ref UInt32 balance);

        [DllImport("umf.dll", EntryPoint = "FWCosDeleteFileSys")]
        public static extern UInt32 FWCosDeleteFileSys(Int32 icdev);



        public Form1()
        {
            InitializeComponent();
        }

        private void btn_test_Click(object sender, EventArgs e)
        {
            Int32 tmphdev = 0;

            tmphdev = fw_init(100, 0);

            if (tmphdev != -1)
            {
                ShowMsg("Link reader ok");
            }
            else
            {
                ShowMsg("Link reader failed");
                return;
            }

            fm12xx_test(tmphdev);

        }

        private void ShowMsg(string str)
        {
            listBox1.Items.Add(str);
        }
        private void fm12xx_test(Int32 icdev)
        {
            int status, i;//the state of each operation
            UInt32 uStatus;
            UInt32 sn = new UInt32();
            byte rlen = new byte();
            byte[] rdata = new byte[1024];//the buffer read from a block
            byte[] showData = new byte[34];//hex type data
            uint[] pval = new uint[1];
            byte[] pChVal = new byte[2];
            byte[] pRBuffer = new byte[1024];
            short lenToRW;
            byte[] pWriteBuffer = new byte[1024];

            byte[] pShowBuf = new byte[1024];

            byte[] pExKey = { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };//external key
            byte[] pFileProKey =  { 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff };//file-protect key
            byte[] pPurchaseKey ={ 0x20, 0x28, 0x9d, 0x08, 0x52, 0xc9, 0x61, 0x60, 0x5b, 0x92, 0xb6, 0x07, 0xca, 0xa3, 0xcc, 0xd9 };//consume key
            byte[] pCreditKey ={ 0xda, 0x40, 0x4f, 0x59, 0xe9, 0xf7, 0x30, 0x05, 0xa8, 0xb9, 0x79, 0x35, 0x73, 0xa8, 0xbd, 0x92 };//recharge key
            byte[] pPin = { 0x11, 0x22, 0x33, 0x44, 0x55, 0x66 };
            byte[] pTerminal = { 0x00, 0x00, 0x00, 0x00, 0x00, 0x01 };//Terminal ID (6 bytes)
            char[] pDirName = { 'a', ' ', 'T', 'e', 's', 't', ' ', 'D', 'i', 'r' };
            string strMsg;

            lenToRW = 0x54;//
            for (i = 0; i < lenToRW; i++) pWriteBuffer[i] = (byte)(i + 3);

            //device reset
            status = fw_reset((IntPtr)icdev, 10);
            if (status != 0)
            {
                ShowMsg("ERROR(" + status.ToString() + "): Device reset failed.\n");
                return;
            }
            ShowMsg("Device reset OK.\n");

            //find card
            status = fw_card(icdev, 1, ref sn);
            if (status != 0)
            {
                ShowMsg("ERROR(" + status.ToString() + "):Find No card.\n");
                return;
            }
            ShowMsg("Find Card: " + sn.ToString());

            //card reset
            status = fw_pro_reset(icdev, ref rlen, ref rdata[0]);
            if (status != 0)
            {
                ShowMsg("ERROR(" + status.ToString() + "): Card reset failed.\n");
                return;
            }
            ShowMsg("Reset ok");


            //select main app
            uStatus = FWCosSelecteApp(icdev);
            if (uStatus != 0)
            {
                ShowMsg("FWCosSelecteApp error!\n");
                fw_exit((int)icdev);
                return;
            }
            else
            {
                ShowMsg("FWCosSelecteApp ok!\n");
            }

            //create key file,used for keys
            uStatus = FWCosCreateKeyFile(icdev,
                (short)0x0000,//current directory
                (short)0x0001,//key ID
                (short)0x0040,//key file length
                0);//The permission
            if (uStatus != 0)
            {
                ShowMsg("FWCosCreateKeyFile error!\n");
                ShowMsg(uStatus.ToString());
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosCreateKeyFile ok!\n");
            }

            //Setup external authenication key
            uStatus = FWCosAddKey(icdev,
                (byte)2,//key type
                ref pExKey[0],//key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[ExKey] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[ExKey] ok!\n");
            }

            //setup file-protect key
            uStatus = FWCosAddKey(icdev,
                (byte)1,//key type
                ref pFileProKey[0],//key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[FileProKey] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[FileProKey] ok!\n");
            }

            //setup pin
            uStatus = FWCosAddKey(icdev,
                (byte)3,//pin type
                ref pPin[0],//pin
                6);//pin length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[Pin] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[Pin] ok!\n");
            }

            //create binary file
            uStatus = FWCosCreateBinaryFile(icdev,
            (short)0x0000,//0 means current direcory
            (short)0x0002,//file ID
            (short)0x0200,//file length
            (byte)1,//data type: 0-plaint, 1-plain+MAC, 2-crypt+MAC
            0,//Read permission case
            1,//Write permission case
            0);//Delete permission case
            if (uStatus != 0)
            {
                ShowMsg("FWCosCreateBinaryFile error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosCreateBinaryFile ok!\n");
            }

            //Authenicate pin
            uStatus = FWCosVerifyKey(icdev,
                ref pPin[0],//pin
                6,//pin length
                3);//pin type
            if (uStatus != 0)
            {
                ShowMsg("FWCosVerifyKey error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosVerifyKey ok!\n");
            }

            //write binary file
            uStatus = FWCosUpdateBinaryFile(icdev,
              (short)0x0002,//file ID
              (short)0x00,//offset 
              ref pWriteBuffer[0],//data
              (short)lenToRW,//data length
              1,//data type: 0-plaint, 1-plain+MAC, 2-crypt+MAC
              ref pFileProKey[0],//file-protect key
              16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosUpdateBinaryFile error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosUpdateBinaryFile ok!\n");
            }

            //Read binary file
            uStatus = FWCosReadBinaryFile(icdev,
                (short)0x0002,//file ID
                ref pRBuffer[0],
                (short)0x00,//offset
                (short)lenToRW,//length
                (Byte)1,//data type: 0-plaint, 1-plain+MAC, 2-crypt+MAC
                ref pFileProKey[0],//file-protect key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosReadBinaryFile error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosReadBinaryFile ok!\n");

                // ShowMsg("%s\n",pRBuffer);
                strMsg = "";
                for (i = 0; i < lenToRW; i++)
                {
                    strMsg += pRBuffer[i].ToString("X2");
                    strMsg += " ";
                }

                ShowMsg(strMsg);
            }

            //***********************************************************************///
            //      value operation
            //**************************************************************************//
            //Create bank directory
            uStatus = FWCosCreateADF(icdev,
                (ushort)0xDF01,//directory ID
                0,//Create file permission
                0,//Delete file perimssion
                ref pDirName[0],//The directory name
                (Byte)10);//length
            if (uStatus != 0)
            {
                ShowMsg("FWCosCreateADF error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("\rFWCosCreateADF ok!\n");
            }


            //setup external key
            uStatus = FWCosAddKey(icdev,
                (Byte)2,//key tpye
                ref pExKey[0],//key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[ExKey] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[ExKey] ok!\n");
            }

 
            //setup pin
            uStatus = FWCosAddKey(icdev,
                (Byte)3,//pin type
                ref pPin[0],//pin
                6);//pin length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[Pin] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[Pin] ok!\n");
            }

            //setup consume key
            uStatus = FWCosAddKey(icdev,
                (Byte)7,//key type
                ref pPurchaseKey[0],//key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[Purchase] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[Purchase] ok!\n");
            }


            //setup charge key
            uStatus = FWCosAddKey(icdev,
                (Byte)5,//key type
                ref pCreditKey[0],//key 
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosAddKey[Credit] error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosAddKey[Credit] ok!\n");
            }


            //verify pin
            uStatus = FWCosVerifyKey(icdev,
                ref pPin[0],//pin
                6,//pin length
                (char)3);//pin type
            if (uStatus != 0)
            {
                ShowMsg("FWCosVerifyKey error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);
                return;

            }
            else
            {
                ShowMsg("FWCosVerifyKey ok!\n");
            }

            //Charge
            uStatus = FWCosCredit(icdev,
                (Byte)0x00,//Charge ID, should be 0
                100000,//money
                ref pTerminal[0],//terminal ID
                ref pCreditKey[0],//charge key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosCredit error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);//֤ⲿ֤Կ
                FWCosDeleteFileSys(icdev);//
                fw_exit((int)icdev);//
                return;

            }
            else
            {
                ShowMsg("FWCosCredit ok!\n");
            }

            //Consume
            uStatus = FWCosPurchase(icdev,
                (Byte)0x01,//Consume ID
                50,//value 
                ref pTerminal[0],//termianl ID
                ref pPurchaseKey[0],//Consume key
                16);//key length
            if (uStatus != 0)
            {
                ShowMsg("FWCosPurchase error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);//
                fw_exit((int)icdev);//
                return;

            }
            else
            {
                ShowMsg("FWCosPurchase ok!\n");
            }

 
            //Query balance
            uStatus = FWCosGetBalance(
                (UInt32)icdev,
                ref pval[0]);
            if (uStatus != 0)
            {
                ShowMsg("FWCosGetBalance error!\n");
                ShowMsg(uStatus.ToString());
                FWCosSelecteApp(icdev);
                FWCosVerifyKey(icdev, ref pExKey[0], 16, 2);
                FWCosDeleteFileSys(icdev);//
                fw_exit((int)icdev);//
                return;

            }
            else
            {
                ShowMsg("FWCosGetBalance ok!\n");
                ShowMsg("balance:" + pval[0].ToString());
            }

            //Select main app
            FWCosSelecteApp(icdev);


            //Verify external key
            uStatus = FWCosVerifyKey(icdev,
                ref pExKey[0],//key
                16,//key length
                2);
            if (uStatus != 0)
            {
                ShowMsg("FWCosVerifyKey error!\n");
                ShowMsg(uStatus.ToString());
                FWCosDeleteFileSys(icdev);
                fw_exit((int)icdev);

            }
            else
            {
                ShowMsg("FWCosVerifyKey ok!\n");
            }

            //delete test app
            uStatus = FWCosDeleteFileSys(icdev);
            if (uStatus != 0)
            {
                ShowMsg("FWCosDeleteFileSys error!\n");
                ShowMsg(uStatus.ToString());
                fw_exit((int)icdev);

            }
            else
            {
                ShowMsg("FWCosDeleteFileSys ok!\n");
            }

            fw_exit((int)icdev);//Close reader
        }

    }
}